; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------
; Amy Twister
[Command]
name = "Twister"
command = ~D, DB, B, D, DB, B, a+x
time = 20

; Amy Cyclone
[Command]
name = "Cyclone"
command = ~D, DB, B, D, DB, B, a
time = 20

; Amy Cyclone
[Command]
name = "Cyclone"
command = ~D, DB, B, D, DB, B, x
time = 20

; Shin Roozu Kou Ren Ken
[Command]
name = "ShinRoozu"
command = ~D, DF, F, D, DF, F, a+x
time = 20

; Roozu Kou Ren Ken
[Command]
name = "Roozu"
command = ~D, DF, F, D, DF, F, a
time = 20

; Rozu Kou Ren Ken
[Command]
name = "Roozu"
command = ~D, DF, F, D, DF, F, x
time = 20

;-| Special Motions |------------------------------------------------------
;Weak_Hammer_Upper
[Command]
name = "HammerW"
command = ~F, D, DF, a

;Strong_Hammer_Upper
[Command]
name = "HammerS"
command = ~F, D, DF, x

; Hammer Whirlwind
[Command]
name = "Wheel"
command = ~B, DB, D, DF, F, a+x

; Rose Whirlwind Weak
[Command]
name = "RoseW"
command = ~F, DF, D, DB, B, a

; Rose Whirlwind Strong
[Command]
name = "RoseS"
command = ~F, DF, D, DB, B, x

;Rubber_Hammer_Weak
[Command]
name = "RHammerW"
command = ~D, DF, F, a

;Rubber_Hammer_Strong
[Command]
name = "RHammerS"
command = ~D, DF, F, x

;Short_Jump_Attack (weak)
[Command]
name = "ShortW"
command = ~D, DB, B, a

;Short_Jump_Attack (strong)
[Command]
name = "ShortS"
command = ~D, DB, B, x

; X repeated
[Command]
name = "x_rep"
command = x, x, x
time = 25

; Y repeated
[Command]
name = "y_rep"
command = y, y, y
time = 25

; A repeated
[Command]
name = "a_rep"
command = a, a, a
time = 25

; B repeated
[Command]
name = "b_rep"
command = b, b, b
time = 25
;--------------------
;-| Charges|-------------
[Command]
name = "chargedownup_a"
command = ~60$D, U, a
time = 10

[Command]
name = "chargedownup_b"
command = ~60$D, U, b
time = 10

[Command]
name = "chargedownup_c"
command = ~60$D, U, c
time = 10

[Command]
name = "chargedownup_x"
command = ~60$D, U, x
time = 10

[Command]
name = "chargedownup_y"
command = ~60$D, U, y
time = 10

[Command]
name = "chargedownup_z"
command = ~60$D, U, z
time = 10

;--------------------
;Charge_Back_fwd
[Command]
name = "chargebackfwd_a"
command = ~60$B, F, a
time = 10

[Command]
name = "chargebackfwd_b"
command = ~60$B, F, b
time = 10

[Command]
name = "chargedownup_c"
command = ~60$D, U, c
time = 10

[Command]
name = "chargedownup_x"
command = ~60$D, U, x
time = 10

[Command]
name = "chargedownup_y"
command = ~60$D, U, y
time = 10

[Command]
name = "chargedownup_z"
command = ~60$D, U, z
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF";Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB";Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
Name = "Knock_Simple"
command = x+y
time = 1

[Command]
Name= "fab"
command = /$F,a+b
time = 1

[Command]
Name= "bab"
command = /$B,a+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1
;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "fwd_z"
command = /F,z
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

[Command]
name = "back_ab"
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name ="c"
command = c
time = 1

[Command]
name = "a"
command = a
time = 1

[Command]
name ="b"
command = b
time = 1

[Command]
name = "Provocate"
command = s

[Command]
Name = "hold_ax"
command = /a+x
time = 1

[Command]
Name = "hold_a"
command = /a
time = 1

[Command]
Name = "hold_x"
command = /x
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "longjump"
command = D, $U
time = 18

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
; SUPER MOTIONS
;===========================================================================
;---------------------------------------------------------------------------
; Amy Twister
[State -1]
type = ChangeState
value = 3030
triggerall = RoundState = 2
triggerall = command = "Twister"
triggerall = Power >= 2000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420

;---------------------------------------------------------------------------
; Amy Cyclone
[State -1]
type = ChangeState
value = 3020
triggerall = RoundState = 2
triggerall = command = "Cyclone"
triggerall = Power >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420

;---------------------------------------------------------------------------
; Shin Roozu Kou Ren Ken
[State -1]
type = ChangeState
value = 3010
triggerall = RoundState = 2
triggerall = command = "ShinRoozu"
triggerall = Power >= 2000
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger2 = Statetype = C
trigger2 = Ctrl = 1
trigger3 = stateno = 200
trigger3 = movecontact = 1
trigger4 = stateno = 100
trigger5 = stateno = 220
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1

;---------------------------------------------------------------------------
; Roozu Kou Ren Ken
[State -1]
type = ChangeState
value = 3000
triggerall = RoundState = 2
triggerall = command = "Roozu"
triggerall = Power >= 1000
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger2 = Statetype = C
trigger2 = Ctrl = 1
trigger3 = stateno = 200
trigger3 = movecontact = 1
trigger4 = stateno = 100
trigger5 = stateno = 220
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1

;===========================================================================
; SPECIAL ATTACKS
;===========================================================================
; Weak Hammer Upper
[State -1]
type = ChangeState
value = 1020
triggerall = command = "HammerW"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
trigger10 = movecontact = 1
trigger10 = stateno = 430
;---------------------------------------------------------------------------
; Strong Hammer Upper
[State -1]
type = ChangeState
value = 1030
triggerall = command = "HammerS"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
;---------------------------------------------------------------------------
; Hammer Whirlwind (Xtreme)
[State -1]
type = ChangeState
value = 1090
triggerall = command = "Wheel"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 220
trigger4 = statetype = C
trigger4 = ctrl = 1
trigger5 = movecontact = 1
trigger5 = stateno = 400
trigger6 = movecontact = 1
trigger6 = stateno = 420

; Fury Attack 2 to 4 times( first follow-up)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1090
trigger1 = command = "a"
trigger2 = command = "x"

; Fury Attack End( second follow-up)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1091
trigger1 = command = "a"
trigger2 = command = "x"

;---------------------------------------------------------------------------
; Rose Whirlwind weak
[State -1]
type = ChangeState
value = 1060
triggerall = command = "RoseW"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
; Rose Whirlwind Strong
[State -1]
type = ChangeState
value = 1080
triggerall = command = "RoseS"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
; Rubber Hammer Weak
[State -1]
type = ChangeState
value = 1000
triggerall = command = "RHammerW"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 220
trigger4 = statetype = C
trigger4 = ctrl = 1
trigger5 = movecontact = 1
trigger5 = stateno = 400
trigger6 = movecontact = 1
trigger6 = stateno = 420

; Rubber Hammer Weak (sequence hammer)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1000
trigger1 = command = "fwd_a"

;---------------------------------------------------------------------------
; Rubber Hammer Strong
[State -1]
type = ChangeState
value = 1010
triggerall = command = "RHammerS"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
trigger10 = movecontact = 1
trigger10 = stateno = 430

; Rubber Hammer Strong (sequence hammer)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1010
trigger1 = command = "fwd_x"
;---------------------------------------------------------------------------
; Short Jump Attack (weak)
[State -1]
type = ChangeState
value = 1039
triggerall = command = "ShortW"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 220
trigger4 = statetype = C
trigger4 = ctrl = 1
trigger5 = movecontact = 1
trigger5 = stateno = 400
trigger6 = movecontact = 1
trigger6 = stateno = 420

; Dive Head Butt (weak)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1040
trigger1 = command = "a"
;---------------------------------------------------------------------------
; Short Jump Attack (strong)
[State -1]
type = ChangeState
value = 1049
triggerall = command = "ShortS"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
trigger10 = movecontact = 1
trigger10 = stateno = 430

; Dive Head Butt (strong)
[State -1]
type = VarSet
v = 1
value = 1
triggerall = stateno = 1050
trigger1 = command = "x"
;---------------------------------------------------------------------------
;Standing_Knockdown_Attack (Normal_Command) 
[State -1]
type = ChangeState
value = 240
triggerall = command = "Knock_Simple"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movehit = 1
trigger3 = stateno = 230
trigger3 = movehit = 1
;---------------------------------------------------------------------------
;===========================================================================
; NORMAL ATTACKS
;===========================================================================
;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Throw (close dir+b)
; Complicated? Skip the throws and look at stand_a, etc, first.
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 900
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = "fwd_b"   ;p2 stand
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H
trigger2 = command = "fwd_b"   ;p2 crouch
trigger2 = stateno != 100    ;Not running
trigger2 = p2statetype = C
trigger2 = p2movetype != H
trigger3 = command = "back_b"  ;p2 stand
trigger3 = p2statetype = S
trigger3 = p2movetype != H
trigger4 = command = "back_b"  ;p2 crouch
trigger4 = p2statetype = C
trigger4 = p2movetype != H

;---------------------------------------------------------------------------
;Air_Throw1 (close dir+b)
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 950
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = p2bodydist X < 9
triggerall = p2bodydist Y > -22
triggerall = p2bodydist Y < 22
triggerall = p2statetype = A
triggerall = p2movetype != H
trigger1 = command = "fwd_b"
trigger2 = command = "back_b"


;===========================================================================
;---------------------------------------------------------------------------
;Forward Dodge 
[State -1]
type = ChangeState
value = 255
trigger1 = command = "fab"
trigger1 = stateno != 255
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Backward Dodge
[State -1]
type = ChangeState
value = 256
triggerall=command="bab"
triggerall = stateno != 256
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Provocate
[State -1]
type = ChangeState
value = 390
triggerall = Var(2) != 1
triggerall = command = "Provocate"
triggerall = Vel X = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Stand_Weak_Punch
[State -1]
type = ChangeState
value = 200
triggerall = command = "a"          ;Place name of command here
triggerall = command != "holddown"  ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 200
trigger4 = time >= 7
;---------------------------------------------------------------------------
;Stand_Hard_Punch
[State -1]
type = ChangeState
value = 210
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 100
;---------------------------------------------------------------------------
;Stand_Weak_Kick
[State -1]
type = ChangeState
value = 220
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
;---------------------------------------------------------------------------
;Stand_Hard_Knee
[State -1]
type = ChangeState
value = 230
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movehit = 1
trigger3 = stateno = 420
trigger3 = movecontact = 1
trigger4 = stateno = 400
trigger4 = movecontact = 1
trigger5 = stateno = 100
;---------------------------------------------------------------------------
;Standing_Knockdown_Attack (Simple_Button) 
[State -1]
type = ChangeState
value = 240
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movehit = 1
trigger3 = stateno = 200
trigger3 = movehit = 1
;---------------------------------------------------------------------------
;Crouch_Light_Punch
[State -1]
type = ChangeState
value = 400
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = time >= 7
trigger2 = stateno = 400
trigger3 = stateno = 420
trigger3 = movecontact = 1
;---------------------------------------------------------------------------
;Crouch_Light_Kick
[State -1]
type = ChangeState
value = 420
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 100
;---------------------------------------------------------------------------
;Crouch_Hard_Punch
[State -1]
type = ChangeState
value = 410
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 400
trigger3 = movecontact = 1
trigger3 = stateno = 420
trigger4 = stateno = 100
;---------------------------------------------------------------------------
;Crouch_Hard_Kick
[State -1]
type = ChangeState
value = 430
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 420
trigger3 = stateno = 100
;---------------------------------------------------------------------------
;Jump_Light_Punch
[State -1]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 610
trigger3 = movecontact = 1
trigger3 = stateno = 620
trigger4 = movecontact = 1
trigger4 = stateno = 630
;---------------------------------------------------------------------------
;Jump_Hard_Punch
[State -1]
type = ChangeState
value = 610
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 600
trigger3 = movecontact = 1
trigger3 = stateno = 620
trigger4 = movecontact = 1
trigger4 = stateno = 630
;--------------------------------------------------------------------------
;Jump_Light_Kick
[State -1]
type = ChangeState
value = 620
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Jump_Hard_Kick
[State -1]
type = ChangeState
value = 630
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 620
trigger3 = movecontact = 1
trigger3 = stateno = 1055
;--------------------------------------------------------------------------